package gov.va.vamf.scheduling.batch.datalayer.reminder;

import gov.va.vamf.scheduling.batch.domain.RecallReminder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import static org.apache.commons.lang.StringUtils.trimToEmpty;

public class RecallReminderResultSetRowMapper implements RowMapper<RecallReminder> {

	private static final int RECALL_DATE_COL = 1;
	private static final int RECALL_PER_PATIENT_DATE_COL = 2;
	private static final int APPOINTMENT_LENGTH_COL = 3;
	private static final int FASTING_COL = 4;
	private static final int RECALL_ENTRY_COMMENT_COL = 5;
	private static final int RECALL_REMINDER_TYPE_COL = 6;
	private static final int RECALL_REMINDER_TYPE_SYNONYM_COL = 7;
	private static final int STAFF_NAME_COL = 8;
	private static final int STAFF_IEN_COL = 9;
	private static final int STAFF_STA3N_COL = 10;
	private static final int PATIENT_LAST_NAME_COL = 11;
	private static final int PATIENT_FIRST_NAME_COL = 12;
	private static final int PATIENT_ICN_COL = 13;
	private static final int PATIENT_ICN_CHECKSUM_COL = 14;
	private static final int CLINIC_LOCATION_NAME_COL = 15;
	private static final int CLINIC_STA3N_COL = 16;
	private static final int CLINIC_IEN_COL = 17;
	private static final int CLINIC_FRIENDLY_LOCATION_NAME_COL = 18;
	private static final int INSTITUTION_NAME_COL = 19;


	@Override
	public RecallReminder mapRow(ResultSet rs, int rowNum) throws SQLException {

		RecallReminder recallReminder = new RecallReminder();

		recallReminder.setRecallDate(rs.getDate(RECALL_DATE_COL));
		recallReminder.setRecallPerPatientDate(rs.getDate(RECALL_PER_PATIENT_DATE_COL));
		recallReminder.setAppointmentLength(rs.getInt(APPOINTMENT_LENGTH_COL));
		recallReminder.setFasting(trimToEmpty(rs.getString(FASTING_COL)));
		recallReminder.setRecallEntryComment(trimToEmpty(rs.getString(RECALL_ENTRY_COMMENT_COL)));
		recallReminder.setRecallReminderType(trimToEmpty(rs.getString(RECALL_REMINDER_TYPE_COL)));
		recallReminder.setRecallReminderTypeSynonym(trimToEmpty(rs.getString(RECALL_REMINDER_TYPE_SYNONYM_COL)));
		recallReminder.setStaffName(trimToEmpty(rs.getString(STAFF_NAME_COL)));
		recallReminder.setStaffIen(trimToEmpty(rs.getString(STAFF_IEN_COL)));
		recallReminder.setStaffSta3n(rs.getInt(STAFF_STA3N_COL));
		recallReminder.setPatientLastName(trimToEmpty(rs.getString(PATIENT_LAST_NAME_COL)));
		recallReminder.setPatientFirstName(trimToEmpty(rs.getString(PATIENT_FIRST_NAME_COL)));
		recallReminder.setPatientIcn(trimToEmpty(rs.getString(PATIENT_ICN_COL)));
		recallReminder.setPatientIcnChecksum(trimToEmpty(rs.getString(PATIENT_ICN_CHECKSUM_COL)));
		recallReminder.setClinicName(trimToEmpty(rs.getString(CLINIC_LOCATION_NAME_COL)));
		recallReminder.setFacilityId(rs.getInt(CLINIC_STA3N_COL));
		recallReminder.setClinicId(trimToEmpty(rs.getString(CLINIC_IEN_COL)));
		recallReminder.setClinicFriendlyName(trimToEmpty(rs.getString(CLINIC_FRIENDLY_LOCATION_NAME_COL)));
		recallReminder.setFacilityName(trimToEmpty(rs.getString(INSTITUTION_NAME_COL)));

		return (recallReminder);
	}
}
